//
//  v002ScreenCapturePlugIn.h
//  v002ScreenCapture
//
//  Created by vade on 6/17/08.
//  Copyright (c) 2008 __MyCompanyName__. All rights reserved.
//

#import <Quartz/Quartz.h>

@interface v002ScreenCapturePlugIn : QCPlugIn
{
	// our fulls screen capture context and texture we are going to re-use
	CGLContextObj fullScreenCaptureContext;

}


@property (assign) double inputOriginX;
@property (assign) double inputOriginY;
@property (assign) double inputWidth;
@property (assign) double inputHeight;

@property (assign) id<QCPlugInOutputImageProvider> outputWindowImage;			

// init our full screen GL context, used by the image provider class to capture a sub texture of the front buffer
- (BOOL) initFullScreenGLContext:(id<QCPlugInContext>)context;

@end

#pragma mark -
#pragma mark Window Image QCPlugInOutputImageProvider
#pragma mark -

@interface windowImageProviderGL : NSObject <QCPlugInOutputImageProvider>
{
	CGLContextObj	fullScreenCaptureContext;
	GLint width, height, originX, originY;
	GLuint screenCaptureTexture;
	
}
- (id) initWithFullScreenContext:(CGLContextObj)context origin:(NSPoint) origin size:(NSSize)size;
@end